define(['angular', 'app', 'global'], function (angular, app) {
	'use strict';

	app.controller('SetGoalsModalController', function (TrackersConstants,
														FitnessGoalsFHIRService,
														$scope,
														$modalInstance,
														$q,
														focusService,
														formatter,
														data,
														authenticationService,
														PatientFHIRService) {



		$scope.$watch(function () {
			return $('div.modal-header h3').is(":visible");
		}, function (isVisible, wasVisible) {
			if (isVisible && !wasVisible) {
				focusService.focusElement($('div.modal-header h3'));
			}
		});

		$scope.data = angular.copy(data);

		$scope.data.target = data.target || {};
		$scope.originalData = angular.copy($scope.data);

		var todaysDate = new Date();
		function getMinAllowedDate() {
			return data.startDate && new Date(data.startDate).getTime() < todaysDate.getTime() ? data.startDate : formatter.getFormattedFrontendDate(todaysDate);
		}

		$scope.allowedDateRange = {
			min : getMinAllowedDate(),
			max : formatter.getFormattedFrontendDate(formatter.getDateTimeMinusDelta(todaysDate, {days:90}, "back"))
		};

		$scope.cleanData = function ($scope) {
			delete $scope.data.activeFlag;
			delete $scope.data.startDate;
			delete $scope.data.target;

		};
		$scope.goalForm = {
			service: FitnessGoalsFHIRService,
			allowedActions: {
				save: true,
				cancel: true,
				edit: true
			}
		};


		$scope.ok = function () {
			allowModalToClose().then(function () {

				$modalInstance.close($scope.data);

			});
		};

		$scope.close = function () {
			$modalInstance.dismiss('cancel');
		};

		$scope.reset = function () {
			$scope.data = angular.copy($scope.originalData);
		};

		if (!$scope.data.startDate) {
			$scope.data.startDate = formatter.getFormattedFrontendDate(new Date());
			var endDate =formatter.getFormattedFrontendDate(formatter.getDateTimeMinusDelta($scope.data.startDate, {days:7}, "front"));

			$scope.data.endDate = endDate;
		}

		$scope.$watch('[data.startDate, data.target.minutes, data.target.steps, data.target.miles]', function(newValues, oldValues) {

				for (var i = 0; i < newValues.length; i++) {
					if (angular.isString(newValues[i]) && newValues[i].length > 0 && newValues[i] !== oldValues[0]) {
						//$scope.data.startDate = formatter.getFormattedFrontendDate(new Date());

             			$scope.data.extension[1].valueString = $scope.data.target.steps;
						$scope.data.component[0].valueQuantity.value = $scope.data.target.minutes;
						$scope.data.component[1].valueQuantity.value = $scope.data.target.miles;
						$scope.data.extension[4].valueString = $scope.data.startDate;

						var endDate =formatter.getFormattedFrontendDate(formatter.getDateTimeMinusDelta($scope.data.startDate, {days:0}, "front"));


						$scope.data.endDate = formatter.getFormattedFrontendDate(formatter.getDateTimeMinusDelta(endDate, {days: 7}, 'front'));
						$scope.data.extension[5].valueString = formatter.getFormattedFrontendDate(formatter.getDateTimeMinusDelta(endDate, {days: 7}, 'front'));
						$scope.data.extension[3].valueString = 'true';
					}
				}
		}, true);




		function allowModalToClose() {


			var defer = $q.defer();
			defer.resolve();

			if (angular.element('.modal-content validation-summary')
				&& angular.element('.modal-content validation-summary').controller('goalForm')) {
				angular.element('.modal-content validation-summary').controller('goalForm').validationSummary.validate().then( function () {

					defer.resolve();
				}, function () {

                    defer.reject();
				});
			} else {
				defer.resolve();
			}

			return defer.promise;
		}
		function loadUserDetails(user) {
			if (user) {
				$scope.userName = user.name[0].text;


			}
		}
	});



});